﻿using UnityEngine;
using UnityEditor;
using FullControl.Tx.View;

public class SetUpCollisionTool : EditorWindow 
{
	bool useConcreteTag = false;
	bool useMetalTag = false;
	bool useWoodTag = false;
	
	[MenuItem("Window/Set Up Collision Tool")]
	public static void ShowWindow()
	{
		//Show existing window instance. If one doesn't exist, make one.
		EditorWindow.GetWindow(typeof(SetUpCollisionTool));
	}
	
	void OnGUI()
	{
		GUILayout.Label ("Groups objects, disables", EditorStyles.boldLabel);
		GUILayout.Label ("mesh renderers and assigns", EditorStyles.boldLabel);
		GUILayout.Label ("a material tag", EditorStyles.boldLabel);

		useConcreteTag = EditorGUILayout.Toggle ("Use Concrete tag", useConcreteTag);
		useMetalTag = EditorGUILayout.Toggle ("Use Metal tag", useMetalTag);
		useWoodTag = EditorGUILayout.Toggle ("Use Wood tag", useWoodTag);

		if(GUILayout.Button("Set up pls!"))
		{
			SetUpCollision();
			Debug.Log("Set up collision is done");
		}
	}
	

	void SetUpCollision()
	{
		//selected object array and the length
		GameObject[] selectedObjects = Selection.gameObjects;
		int numberOfSelectedObjects = selectedObjects.Length;

		GameObject parentObject = new GameObject("Collision");
		parentObject.transform.position = selectedObjects[0].transform.position;
	

		for (int i = 0; i < numberOfSelectedObjects; i++) 
		{
			selectedObjects[i].transform.parent = parentObject.transform;
			selectedObjects[i].GetComponent<MeshRenderer>().enabled = false;

			if(useConcreteTag)
			{
				selectedObjects[i].tag = "MaterialConcrete";
			}
			else if(useMetalTag)
			{
				selectedObjects[i].tag = "MaterialMetal";
			}
			else if(useWoodTag)
			{
				selectedObjects[i].tag = "MaterialWood";
			}
		}
		Selection.activeObject = parentObject;
		
	}







	
}